<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\Model\Entities\Seller;
use EshopCatalog\Model\Entities\SellerInSite;
use Override;

/**
 * @method Seller|null getReference($id)
 * @method Seller|null get($id)
 */
class Sellers extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Seller::class;

	public function getSitesInUse(): array
	{
		$result = [];

		foreach ($this->em->getRepository(SellerInSite::class)->createQueryBuilder('s')
			         ->select('seller.id as sellerId, IDENTITY(s.site) as site, seller.title as sellerName')
			         ->innerJoin('s.seller', 'seller')
			         ->getQuery()->getArrayResult() as $row) {
			$result[$row['site']] = $row;
		}

		return $result;
	}

	/**
	 * @return Seller[]
	 */
	#[Override]
	public function getAll(): array
	{
		$arr = [];

		foreach (parent::getAll() as $row) {
			$arr[$row->getId()] = $row;
		}

		return $arr;
	}

	public function getSellerForSite(string $siteIdent): ?Seller
	{
		$qb = $this->getEr()->createQueryBuilder('s');
		$qb->join('s.sites', 'sites', Join::WITH, 'sites.site = :site');
		$qb->setParameter('site', $siteIdent);

		return $qb->getQuery()->setMaxResults(1)->getOneOrNullResult();
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];
		foreach ($this->getEr()->createQueryBuilder('s')->select('s.id, s.title')
			         ->getQuery()->getScalarResult() as $row) {
			$arr[$row['id']] = $row['title'];
		}

		return $arr;
	}

}
