<?php declare(strict_types = 1);

namespace EshopCatalog\Console\AdminTools;

use Core\Model\Sites;
use Doctrine;
use EshopCatalog\AdminModule\Model\AdminTools\ZboziCustomColumn;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'eshop-catalog:admin-tools:zbozi-custom-column-import')]
class ZboziCustomColumnImport extends Command
{
	public function __construct(
		protected Sites             $sites,
		protected ZboziCustomColumn $zboziCustomColumn,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-catalog:admin-tools:zbozi-custom-column-import');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Start');

		try {
			Debugger::dispatch();

			$output->writeLn('<info>Preloading changed</info>');
			$this->zboziCustomColumn->preloadChanged();
			foreach ($this->sites->getSites() as $site) {
				$siteIdent = $site->getIdent();

				$output->writeLn('<info>Importing - ' . $siteIdent . '</info>');

				$this->zboziCustomColumn->processData($siteIdent);
			}

			$output->writeLn('<info>Clear prev old</info>');
			$this->zboziCustomColumn->resetPrevChanged();

			$output->writeLn('<info>[OK] - Checked</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
