<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use EshopCatalog\FrontModule\Model\Manufacturers;
use Nette\Application\ForbiddenRequestException;

class ManufacturersPresenter extends BasePresenter
{
	public function __construct(
		protected Manufacturers $manufacturers,
	)
	{
	}

	public function actionManufacturers(): void
	{
		if (!$this->getUser()->isAllowed('Core:Admin', 'access')) {
			throw new ForbiddenRequestException;
		}

		$lang = $this->getParameter('lang', null);
		if ($lang) {
			$this->translator->setLocale($lang);
		}

		$data = [];
		foreach ($this->manufacturers->getManufacturers() as $manu) {
			$data[] = [
				'id'   => $manu->id,
				'name' => $manu->name,
			];
		}

		$this->sendJson($data);
	}

}
