<?php declare(strict_types = 1);

namespace EshopCatalog\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopCatalogExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopCatalog' => 'EshopCatalog\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');
		$this->getContainerBuilder();

		$init->addBody('EshopCatalog\Model\Config::setParams($this->parameters[\'eshopCatalog\']);');
		$init->addBody('$this->getService(\'eshopCatalog.front.categories\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.products\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.productsFacade\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.featureProducts\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.featureProducts\')->navigations = $this->getService(\'navigations.navigations\');');
	}
}
