<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;

class AlternativeProducts extends PersonalizationControl
{
	public function __construct(
		protected Personalization              $personalization,
		protected PersonalizationAccessControl $personalizationAccessControl,
	)
	{
	}

	public function render(int $productId): void
	{
		$this->template->apiUrlCtr  = $this->link('sendCtr!');
		$this->template->productId  = $productId;
		$this->template->productIds = $this->personalization->getAlternativeProductIds($productId);
		$this->template->render($this->getTemplateFile());
	}

	public function handleSendCtr(): void
	{
		$req = $this->presenter->request;
		$this->personalization->increaseCtr((int) $req->getParameter('id'), (int) $req->getPost('productId'));
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isAlternativeProductsAllowed();
	}

}
