<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use Core\Model\Application\AppState;
use Core\Model\UI\BaseControl;
use Currency\Model\Entities\Currency;
use EshopCatalog\FrontModule\Model\Dao\Category;
use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;

class BestSellingProducts extends BaseControl
{
	protected string $currency;
	protected string $currencyText;

	public function __construct(
		protected Personalization              $personalization,
		protected PersonalizationAccessControl $personalizationAccessControl
	)
	{
		/** @var Currency|null $currency */
		$currency           = AppState::getState('currency');
		$this->currency     = $currency ? $currency->getCode() : 'czk';
		$this->currencyText = $currency ? $currency->symbol : 'Kč';
	}

	public function render(Category $category = null): void
	{
		$this->template->currencyText = $this->currencyText;
		$this->template->products     = $this->personalization->getBestSellingProducts($category instanceof Category ? $category->getId() : null);
		$this->template->render($this->getTemplateFile());
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isBestSellingProductsAllowed();
	}

}
