<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use Core\Model\UI\BaseControl;
use EshopCatalog\Model\Config;
use Nette\ComponentModel\IComponent;
use Override;

abstract class PersonalizationControl extends BaseControl
{
	protected string $apiBaseUrl;
	protected string $apiToken;

	#[Override]
	protected function attached(IComponent $presenter): void
	{
		parent::attached($presenter);

		$this->apiBaseUrl = (string) Config::loadScalar('personalization.baseApiUrl');
		$this->apiToken   = (string) Config::loadScalar('personalization.apiToken');
	}

}
