<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\CartItem;
use Nette\Utils\Validators;

class RecentlyViewedProducts extends PersonalizationControl
{
	public function __construct(
		protected Personalization              $personalization,
		protected PersonalizationAccessControl $personalizationAccessControl,
		protected Carts                        $carts,
	)
	{
	}

	public function render(): void
	{
		$defaultTitle = true;
		$exclude      = [];

		// pokud jsme v kosiku, nezobrazovat naposledy navstivene produkty, ktere jsou v kosiku
		if ($this->presenter->getAction(true) === ':EshopOrders:Front:Default:order') {
			$defaultTitle = false;

			$exclude = array_filter(
				array_map(static fn(CartItem $item): ?int => $item->getProductId(), $this->carts->getCurrentCart()->getCartItems()),
				static fn($id): bool => !Validators::isNone($id)
			);
		}

		$this->template->defaultTitle = $defaultTitle;
		$this->template->productIds   = $this->personalization->getRecentlyViewedProducts($exclude);
		$this->template->render($this->getTemplateFile());
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isRecentlyViewedProductsAllowed();
	}

}
