<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Spatie\SchemaOrg\ItemAvailability;

class Availability
{
	protected ?string $name        = null;
	protected ?string $description = null;

	protected ?int $delay = null;

	protected ?string $textColor = null;
	protected ?string $bgColor   = null;

	protected int $canShowOnList   = 1;
	protected int $canShowOnSearch = 1;
	protected int $canAddToCart    = 1;

	protected ?string $openGraphText      = null;
	public int        $warehouseOverdraft = 0;
	public int        $position           = 0;
	public int        $showInFilter       = 1;

	public function __construct(
		protected int    $id,
		protected string $ident,
	)
	{
	}

	public function setData(array $data): void
	{
		foreach ($data as $k => $v) {
			$this->$k = $v;
		}
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getIdent(): string
	{
		return $this->ident;
	}

	public function getName(): string
	{
		return $this->name;
	}

	public function getDescription(): string
	{
		return $this->description;
	}

	public function getDelay(): int
	{
		return $this->delay;
	}

	public function getTextColor(): string
	{
		return $this->textColor;
	}

	public function getBgColor(): string
	{
		return $this->bgColor;
	}

	public function canShowOnList(): int
	{
		return $this->canShowOnList;
	}

	public function canShowOnSearch(): int
	{
		return $this->canShowOnSearch;
	}

	public function canAddToCart(): int
	{
		return $this->canAddToCart;
	}

	public function getOpenGraphText(): ?string
	{
		return $this->openGraphText;
	}

	public function getSchemaUrl(): string
	{
		switch ($this->getOpenGraphText()) {
			case 'in stock':
				return ItemAvailability::InStock;
			case 'preorder':
			case 'available for order':
				return ItemAvailability::PreOrder;
			case 'discontinued':
				return ItemAvailability::Discontinued;
			default:
				if ($this->ident === 'inStock') {
					return ItemAvailability::InStock;
				}

				return ItemAvailability::SoldOut;
		}
	}

	public function getStyle(): string
	{
		$arr = [];

		if ($this->getTextColor() !== '' && $this->getTextColor() !== '0') {
			$arr[] = 'color:' . $this->getTextColor();
		}
		if ($this->getBgColor() !== '' && $this->getBgColor() !== '0') {
			$arr[] = 'background-color:' . $this->getBgColor();
		}

		return implode(';', $arr) . ';';
	}

}
