<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Entities\Feature;

class FeatureProduct
{
	public ?int $idProduct = null;

	/** @var int|string|null */
	public $idFeature;

	/** @var int|string|null */
	public $idFeatureValue;

	public ?int $position      = null;
	public ?int $valuePosition = null;

	public ?string $name                    = null;
	public ?string $value                   = null;
	public ?string $rawValue                = null;
	public ?string $unit                    = null;
	public string  $type                    = Feature::TYPE_CHECK;
	public string  $valueType               = Feature::VALUE_TYPE_TEXT;
	public ?string $image                   = null;
	public ?string $featureImage            = null;
	public bool    $showAsTag               = false;
	public ?string $tagTextColor            = null;
	public ?string $tagBgColor              = null;
	public ?string $productTabTitle         = null;
	public ?string $tagText                 = null;
	public ?string $shortDescription        = null;
	public ?string $longDescription         = null;
	public ?string $moreLink                = null;
	public int     $useForVariantDiff       = 1;
	public array   $extraFields             = [];
	public int     $showInProduct           = 1;
	public int     $showInExport            = 1;
	public int     $showFilterLinkInProduct = 0;

	public int $seoNoFollow = 0;

	public function getKey(): string { return $this->idFeature . '-' . ($this->idFeatureValue ?: $this->rawValue); }

	public function getTagStyle(): string
	{
		$arr = [];

		if ($this->tagTextColor) {
			$arr[] = 'color:' . $this->tagTextColor;
		}
		if ($this->tagBgColor) {
			$arr[] = 'background-color:' . $this->tagBgColor;
		}

		return implode(';', $arr);
	}

	public function setExtraFields(array $array): self
	{
		$this->extraFields = $array;

		return $this;
	}

	public function getExtraFields(): array { return $this->extraFields; }

	/**
	 * @return mixed|null
	 */
	public function getExtraField(string $key, mixed $default = null) { return $this->extraFields[$key] ?? $default; }

}
