<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Entities\Feature;

class FilterItem
{
	public bool $isActive = false;

	public int $productsCountInit = 0;
	public int $productsCount     = 0;

	public ?string $rodM = null;
	public ?string $rodZ = null;
	public ?string $rodS = null;

	public array  $customData = [];
	public string $valueType  = Feature::VALUE_TYPE_TEXT;

	public ?int $seoNoFollow = null;

	public function __construct(
		public string $type,
		public int    $id,
		public string $value,
	)
	{
	}

	/**
	 * @return mixed|null
	 */
	public function getCustomData(string $key) { return $this->customData[$key] ?? null; }

}
