<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Dao\Country;

class Manufacturer
{
	public ?string $description = null;
	public ?string $logo        = null;
	public ?string $website     = null;

	public ?Country $country     = null;
	public ?string  $street      = null;
	public ?string  $zipCode     = null;
	public ?string  $city        = null;
	public ?string  $email       = null;
	public ?string  $contactLink = null;
	public ?string  $phone       = null;

	public function __construct(
		public int    $id,
		public string $name,
	)
	{
	}
}
