<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Dao\Country;
use Nette\Utils\Html;

class Seller
{
	public ?string  $title    = null;
	public ?string  $name     = null;
	public ?string  $street   = null;
	public ?string  $city     = null;
	public ?string  $postal   = null;
	public ?Country $country  = null;
	public ?string  $street2  = null;
	public ?string  $city2    = null;
	public ?string  $postal2  = null;
	public ?Country $country2 = null;
	public ?string  $ic       = null;
	public ?string  $dic      = null;
	public ?string  $email    = null;
	public ?string  $phone    = null;

	/** @var BankAccount[] */
	protected array $bankAccounts        = [];
	public bool     $sendOrderToSeller   = true;
	public bool     $sendStatusToSeller  = true;
	public string   $sendSellerEmailType = 'seller';

	public function __construct(
		public int $id,
	)
	{
	}

	public function getBankAccount(?string $currency = null): ?BankAccount
	{
		if ($currency) {
			$currency = strtolower($currency);

			if (isset($this->bankAccounts[$currency]) && $this->bankAccounts[$currency]->numberPart1) {
				return $this->bankAccounts[$currency];
			}
		}

		/** @var BankAccount|null $czk */
		$czk = $this->bankAccounts['czk'];

		return $czk ?? array_values($this->bankAccounts)[0];
	}

	public function addBankAccount(BankAccount $bankAccount): self
	{
		$this->bankAccounts[$bankAccount->currencyCode] = $bankAccount;

		return $this;
	}

	public function renderAddress(string $number = '', array $skip = []): Html
	{
		$wrap = Html::el();

		if ($this->{'street' . $number}) {
			$wrap->addHtml(Html::el('div')->setText($this->{'street' . $number}));
		}

		$postal = $this->{'postal' . $number} ?? null;
		if ($this->{'city' . $number}) {
			$wrap->addHtml(Html::el('div')->setText(($postal ? $postal . ', ' : '') . $this->{'city' . $number}));
		}

		if ($this->{'country' . $number} && !in_array('country', $skip)) {
			$wrap->addHtml(Html::el('div')->setText($this->{'country'}->getName()));
		}

		return $wrap;
	}

	public function isVatPayer(): bool { return (bool) $this->dic; }

}
