<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

class Video
{
	public function __construct(
		protected ?string $title,
		protected ?string $url,
		protected ?string $lang = null,
		protected ?string $thumbnail = null,
	)
	{
	}

	public function getTitle(): ?string
	{
		return $this->title;
	}

	public function getUrl(): ?string
	{
		return $this->url;
	}

	public function getThumbnail(): ?string
	{
		return $this->thumbnail;
	}

	public function getLang(): ?string { return $this->lang; }

	public function getType(): ?string
	{
		if (!$this->url) {
			return null;
		}

		if (str_starts_with($this->url, 'http')) {
			return 'url';
		} else if (str_starts_with($this->url, 'c')) {
			return 'iframe';
		}

		return 'file';
	}

	/**
	 * Zjisti, zda je url odkazem na mistni soubor nebo externim linkem (napr. youtube)
	 */
	public function isLocalFile(): bool
	{
		return !str_starts_with((string) $this->url, 'http');
	}

}
