<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use Core\Model\UI\FrontPresenter;
use EshopCatalog\FrontModule\Model\Dao\Category;
use EshopCatalog\FrontModule\Presenters\DefaultPresenter;
use Symfony\Contracts\EventDispatcher\Event;

class CategoryHeadEvent extends Event
{
	/** @var DefaultPresenter|null */
	public ?FrontPresenter $presenter = null;

	public function __construct(
		public string   &$title,
		public string   &$categoryName,
		public string   &$description,
		public string   &$metaDescription,
		public array    $activeFilters,
		public Category $category,
	)
	{
	}

}
