<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use EshopCatalog\FrontModule\Model\Dao\Product;
use Symfony\Contracts\EventDispatcher\Event;

class ProductsEvent extends Event
{
	/** @var Product[] */
	public array $products = [];

	/** @param Product[] $products */
	public function __construct(array $products)
	{
		/** @var Product|object $v */
		foreach ($products as $k => $v) {
			if ($v instanceof Product === false) {
				continue;
			}

			$this->products[$k] = $v;
		}
	}
}
