<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Helpers;

use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\FrontModule\Model\PublicHolidays;
use Core\Model\Application\AppState;
use Core\Model\Helpers\Strings;
use Core\Model\Settings;
use Core\Model\Sites;
use Navigations\Model\Navigations;

class ProductsHelper
{
	public function __construct(
		protected Settings       $settings,
		protected Sites          $sites,
		protected PublicHolidays $publicHolidays,
		protected Navigations    $navigations,
		protected Translator     $translator,
		protected AppState       $appState,
	)
	{
	}

	public function getDeliveryToDate(int $addDays = 0, string $overrideTimeTo = null, bool $useSupplierDate = false): ?\DateTime
	{
		$country   = $this->appState->getCountry();
		$siteIdent = $this->sites->getCurrentSite()->getIdent();

		$timeTo = $overrideTimeTo ?? $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionTo');
		if (!$timeTo) {
			return null;
		}

		$skipDates = array_keys($this->publicHolidays->getAll());
		$skipDates = array_flip($skipDates);

		$deliveryDate = new \DateTime();
		$numDay       = (int) $deliveryDate->format('N');
		if ($numDay !== 6 && ($numDay === 7 || isset($skipDates[$deliveryDate->format('Y-m-d')]) || $deliveryDate->format('H:i') > $timeTo)) {
			$addDays += 1;
		}

		$configBaseDays = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionDeliveryBaseDays' . ($useSupplierDate ? 'Supplier' : '') . Strings::upper($country));

		// TODO toto pozdeji odstranit
		if ($configBaseDays === null || $configBaseDays === '') {
			$configBaseDays = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionDeliveryBaseDays');
		}

		if (is_numeric($configBaseDays)) {
			$baseDays = $addDays + (int) $configBaseDays;
		} else {
			$baseDays = $addDays + 1;
		}

		while ($baseDays > 0 || isset($skipDates[$deliveryDate->format('Y-m-d')]) || in_array((int) $deliveryDate->format('N'), [6, 7], true)) {
			$skippedDate = isset($skipDates[$deliveryDate->format('Y-m-d')]) || in_array((int) $deliveryDate->format('N'), [6, 7], true);
			$deliveryDate->modify('+1 day');
			if (!$skippedDate) {
				--$baseDays;
			}
		}

		return $deliveryDate;
	}

	public function getDeliveryToDescription(): ?string
	{
		$siteIdent = $this->sites->getCurrentSite()->getIdent();

		$description = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryExpeditionToDesc');
		if (!$description || !is_string($description)) {
			return null;
		}

		$page = $this->settings->getByKey('eshopCatalog' . Strings::firstUpper($siteIdent) . 'DeliveryPage');
		if ($page) {
			$nav = $this->navigations->getNavigation($page, $this->translator->getLocale());

			if ($nav instanceof DaoNavigationItem) {
				$description .= ' <a href="' . $nav->getLink() . '" target="_blank">' . $this->translator->translate('eshopCatalogFront.product.moreAboutDelivery') . '</a>';
			}
		}

		return nl2br($description);
	}
}
