<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Arrays;
use DateTime;
use EshopCatalog\Model\Config;

class SearchHistoryService
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function saveSearch(string $text, string $siteIdent): void
	{
		$today     = (new DateTime())->format('Y-m-d');
		$currentIp = $_SERVER['REMOTE_ADDR'] ?? '';

		if (Arrays::contains((array) Config::load('saveSearchIpSkip') ?: [], $currentIp)) {
			return;
		}

		$text = trim($text);
		if ($text === '') {
			return;
		}

		$exist = $this->em->getConnection()->fetchOne(
			'SELECT id FROM eshop_catalog__search_history WHERE `created_at` = ? AND `site_id` = ? AND `text` = ?',
			[$today, $siteIdent, $text]
		);
		if ($exist) {
			$this->em->getConnection()->executeQuery(
				'UPDATE eshop_catalog__search_history SET views = views + 1 WHERE id = ?',
				[$exist]
			);
		} else {
			$this->em->getConnection()->executeQuery(
				'INSERT INTO eshop_catalog__search_history (`text`, `created_at`, `site_id`, `views`) VALUES (?, ?, ?, 1)',
				[$text, $today, $siteIdent]
			);
		}
	}
}
