<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\FrontPresenter;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class BaseSubscriber implements EventSubscriberInterface
{
	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::beforeRender' => 'beforeRender',
		];
	}

	public function beforeRender(ControlEvent $event): void
	{
		$event->control['jsTranslates']->addTranslates([
			'cartAddFormAssortPopupTitle'     => 'eshopCatalogFront.product.isAssortPopup',
			'cartAddFromAssortPopupCancel'    => 'eshopCatalogFront.product.cancel',
			'cartAddFormAssortPopupAddToCart' => 'eshopCatalogFront.product.addToCart',
			'eshopCatalogNote'                => 'eshopCatalogFront.product.note',
			'eshopCatalogAssortPlaceholder'   => 'eshopCatalogFront.product.assortPlaceholder',
		]);
	}

}
