<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use EshopCatalog\Model\Personalization\Personalization;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Personalization $personalization,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess'       => ['orderOnSuccess', 100],
			'eshopOrders.admin.orderOnSuccess' => ['orderOnSuccess', 100],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		$this->personalization->putOrder($event->order);
	}

}
