<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Presenters;

use EshopCatalog\FrontModule\Model\OrderDocuments;
use EshopCatalog\Model\Entities\ProductDocument;
use Nette\Application\BadRequestException;
use Nette\Application\Responses\FileResponse;

class DocumentsPresenter extends BasePresenter
{
	public function __construct(
		protected OrderDocuments $orderDocuments,
	)
	{
		parent::__construct();
	}

	public function actionOpen(int $id, int $order, int $product): void
	{
		$document = $this->orderDocuments->find($id, $order, $product);

		if (!$document instanceof ProductDocument) {
			throw new BadRequestException;
		}

		$this->sendResponse(new FileResponse($document->getFullPath(), basename($document->file), null, true));
	}

}
