<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Presenters;

use EshopCatalog\FrontModule\Components\IVariantsPopupFactory;
use EshopCatalog\FrontModule\Components\VariantsPopup;
use EshopCatalog\FrontModule\Model\ProductsFacade;

class VariantPresenter extends BasePresenter
{
	public function __construct(
		protected ProductsFacade $productsFacade
	)
	{
		parent::__construct();
	}

	public function actionOpen(int $id): void
	{
		if (!$this->getHttpRequest()->getQuery('do')) {
			$this->redrawControl('variant');
			$this->payload->toModal = 'snippet--variant';
		}
	}

	protected function createComponentVariant(IVariantsPopupFactory $factory): VariantsPopup
	{
		return $factory->create($this->productsFacade->getProduct((int) $this->getParameter('id')));
	}
}
