<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190520081335 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__attribute_texts DROP FOREIGN KEY FK_6A216449BF396750');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value DROP FOREIGN KEY FK_69632FC2B6E62EFA');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value_texts DROP FOREIGN KEY FK_E529500BBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination DROP FOREIGN KEY FK_EF000F521711780A');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination DROP FOREIGN KEY FK_EF000F5265ED3161');
		$this->addSql('CREATE TABLE eshop_catalog__product_export (id INT AUTO_INCREMENT NOT NULL, is_zbozi SMALLINT NOT NULL, is_heureka SMALLINT NOT NULL, is_google SMALLINT NOT NULL, INDEX id_name (id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_tag (id_product INT NOT NULL, id_tag INT NOT NULL, valid_from DATETIME DEFAULT NULL, valid_to DATETIME DEFAULT NULL, INDEX IDX_AF3C30F7DD7ADDD (id_product), INDEX IDX_AF3C30F79D2D5FD9 (id_tag), PRIMARY KEY(id_product, id_tag)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_variant (id INT AUTO_INCREMENT NOT NULL, id_product INT DEFAULT NULL, is_default SMALLINT NOT NULL, quantity INT NOT NULL, ean VARCHAR(20) DEFAULT NULL, code1 VARCHAR(60) DEFAULT NULL, code2 VARCHAR(60) DEFAULT NULL, unit_price_impact NUMERIC(10, 2) DEFAULT NULL, INDEX IDX_B7B6305DDD7ADDD (id_product), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_variant_combination (id_product_variant INT NOT NULL, id_variant_value INT NOT NULL, id_variant INT DEFAULT NULL, INDEX IDX_A5E7EE85C9C46795 (id_product_variant), INDEX IDX_A5E7EE8523D5160C (id_variant_value), INDEX IDX_A5E7EE852FDE16DD (id_variant), PRIMARY KEY(id_product_variant, id_variant_value)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_variant_supplier (id_supplier INT NOT NULL, id_product_variant INT NOT NULL, quantity INT NOT NULL, INDEX IDX_F7508515CBF180EB (id_supplier), INDEX IDX_F7508515C9C46795 (id_product_variant), PRIMARY KEY(id_supplier, id_product_variant)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__tag (id INT AUTO_INCREMENT NOT NULL, type VARCHAR(255) NOT NULL, image VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__tag_texts (lang VARCHAR(2) NOT NULL, tag INT NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_469D63AB389B783 (tag), PRIMARY KEY(tag, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__variant (id INT AUTO_INCREMENT NOT NULL, use_filter SMALLINT NOT NULL, type SMALLINT NOT NULL, position INT NOT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__variant_text (lang VARCHAR(2) NOT NULL, variant_id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_E5F13513B69A9AF (variant_id), INDEX lang_id_name (lang, variant_id, name), PRIMARY KEY(variant_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__variant_value (id INT AUTO_INCREMENT NOT NULL, variant_id INT DEFAULT NULL, position INT NOT NULL, is_published SMALLINT NOT NULL, INDEX IDX_42EBAF13B69A9AF (variant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__variant_value_text (lang VARCHAR(2) NOT NULL, variant_value_id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_378AAE2166F0FA2A (variant_value_id), INDEX lang_id_name (lang, variant_value_id, name), PRIMARY KEY(variant_value_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__product_tag ADD CONSTRAINT FK_AF3C30F7DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_tag ADD CONSTRAINT FK_AF3C30F79D2D5FD9 FOREIGN KEY (id_tag) REFERENCES eshop_catalog__tag (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant ADD CONSTRAINT FK_B7B6305DDD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE85C9C46795 FOREIGN KEY (id_product_variant) REFERENCES eshop_catalog__product_variant (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE8523D5160C FOREIGN KEY (id_variant_value) REFERENCES eshop_catalog__variant_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE852FDE16DD FOREIGN KEY (id_variant) REFERENCES eshop_catalog__variant (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_supplier ADD CONSTRAINT FK_F7508515CBF180EB FOREIGN KEY (id_supplier) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_supplier ADD CONSTRAINT FK_F7508515C9C46795 FOREIGN KEY (id_product_variant) REFERENCES eshop_catalog__product_variant (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__tag_texts ADD CONSTRAINT FK_469D63AB389B783 FOREIGN KEY (tag) REFERENCES eshop_catalog__tag (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__variant_text ADD CONSTRAINT FK_E5F13513B69A9AF FOREIGN KEY (variant_id) REFERENCES eshop_catalog__variant (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value ADD CONSTRAINT FK_42EBAF13B69A9AF FOREIGN KEY (variant_id) REFERENCES eshop_catalog__variant (id)');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value_text ADD CONSTRAINT FK_378AAE2166F0FA2A FOREIGN KEY (variant_value_id) REFERENCES eshop_catalog__variant_value (id) ON DELETE CASCADE');
		$this->addSql('DROP TABLE eshop_catalog__attribute');
		$this->addSql('DROP TABLE eshop_catalog__attribute_texts');
		$this->addSql('DROP TABLE eshop_catalog__attribute_value');
		$this->addSql('DROP TABLE eshop_catalog__attribute_value_texts');
		$this->addSql('DROP TABLE eshop_catalog__product_attribute');
		$this->addSql('DROP TABLE eshop_catalog__product_attribute_combination');
		$this->addSql('ALTER TABLE eshop_catalog__category ADD created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, ADD modified DATETIME DEFAULT NULL');
		$this->addSql('CREATE INDEX publish_id_id_lft ON eshop_catalog__category (is_published, id, parent_id, lft)');
		$this->addSql('CREATE INDEX root_lft_id ON eshop_catalog__category (tree_root, lft, id)');
		$this->addSql('ALTER TABLE eshop_catalog__feature CHANGE position position INT NOT NULL, CHANGE is_published is_published SMALLINT DEFAULT 1 NOT NULL, CHANGE use_filter use_filter SMALLINT DEFAULT 0 NOT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE46A018358');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4C14ADC16');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4DD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE46A018358 FOREIGN KEY (id_feature_value) REFERENCES eshop_catalog__feature_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4C14ADC16 FOREIGN KEY (id_feature) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value DROP FOREIGN KEY FK_4DFA2FA560E4B879');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value ADD position INT NOT NULL, ADD is_published SMALLINT DEFAULT 0');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value ADD CONSTRAINT FK_4DFA2FA560E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__manufacturer ADD position INT NOT NULL');
		$this->addSql('CREATE INDEX id_name ON eshop_catalog__manufacturer (id, name)');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD id_product_export INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED01D96EA36 FOREIGN KEY (id_product_export) REFERENCES eshop_catalog__product_export (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_54FD0ED01D96EA36 ON eshop_catalog__product (id_product_export)');
		$this->addSql('CREATE INDEX published ON eshop_catalog__product (is_published, id)');
		$this->addSql('CREATE INDEX published_cat ON eshop_catalog__product (is_published, id_category_default, id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDCBF180EB');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDDD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDCBF180EB FOREIGN KEY (id_supplier) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDDD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_texts CHANGE short_description short_description VARCHAR(255) DEFAULT NULL');
		$this->addSql('CREATE INDEX lang ON eshop_catalog__product_texts (lang)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED01D96EA36');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE85C9C46795');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_supplier DROP FOREIGN KEY FK_F7508515C9C46795');
		$this->addSql('ALTER TABLE eshop_catalog__product_tag DROP FOREIGN KEY FK_AF3C30F79D2D5FD9');
		$this->addSql('ALTER TABLE eshop_catalog__tag_texts DROP FOREIGN KEY FK_469D63AB389B783');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE852FDE16DD');
		$this->addSql('ALTER TABLE eshop_catalog__variant_text DROP FOREIGN KEY FK_E5F13513B69A9AF');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value DROP FOREIGN KEY FK_42EBAF13B69A9AF');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE8523D5160C');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value_text DROP FOREIGN KEY FK_378AAE2166F0FA2A');
		$this->addSql('CREATE TABLE eshop_catalog__attribute (id INT AUTO_INCREMENT NOT NULL, position SMALLINT NOT NULL, use_filter SMALLINT NOT NULL, type SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_texts (lang VARCHAR(2) NOT NULL COLLATE utf8_unicode_ci, id INT NOT NULL, name VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, INDEX IDX_6A216449BF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_value (id INT AUTO_INCREMENT NOT NULL, attribute_id INT DEFAULT NULL, INDEX IDX_69632FC2B6E62EFA (attribute_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_value_texts (lang VARCHAR(2) NOT NULL COLLATE utf8_unicode_ci, id INT NOT NULL, name VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, INDEX IDX_E529500BBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('CREATE TABLE eshop_catalog__product_attribute (id INT AUTO_INCREMENT NOT NULL, id_product INT DEFAULT NULL, is_default SMALLINT NOT NULL, quantity INT NOT NULL, ean VARCHAR(20) DEFAULT NULL COLLATE utf8_unicode_ci, code1 VARCHAR(60) DEFAULT NULL COLLATE utf8_unicode_ci, code2 VARCHAR(60) DEFAULT NULL COLLATE utf8_unicode_ci, unit_price_impact NUMERIC(10, 2) DEFAULT NULL, INDEX IDX_93C1D602DD7ADDD (id_product), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('CREATE TABLE eshop_catalog__product_attribute_combination (id_product_attribute INT NOT NULL, id_attribute_value INT NOT NULL, INDEX IDX_EF000F5265ED3161 (id_product_attribute), INDEX IDX_EF000F521711780A (id_attribute_value), PRIMARY KEY(id_product_attribute, id_attribute_value)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_texts ADD CONSTRAINT FK_6A216449BF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__attribute (id) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value ADD CONSTRAINT FK_69632FC2B6E62EFA FOREIGN KEY (attribute_id) REFERENCES eshop_catalog__attribute (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value_texts ADD CONSTRAINT FK_E529500BBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__attribute_value (id) ON UPDATE NO ACTION ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute ADD CONSTRAINT FK_93C1D602DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination ADD CONSTRAINT FK_EF000F521711780A FOREIGN KEY (id_attribute_value) REFERENCES eshop_catalog__attribute_value (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination ADD CONSTRAINT FK_EF000F5265ED3161 FOREIGN KEY (id_product_attribute) REFERENCES eshop_catalog__product_attribute (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('DROP TABLE eshop_catalog__product_export');
		$this->addSql('DROP TABLE eshop_catalog__product_tag');
		$this->addSql('DROP TABLE eshop_catalog__product_variant');
		$this->addSql('DROP TABLE eshop_catalog__product_variant_combination');
		$this->addSql('DROP TABLE eshop_catalog__product_variant_supplier');
		$this->addSql('DROP TABLE eshop_catalog__tag');
		$this->addSql('DROP TABLE eshop_catalog__tag_texts');
		$this->addSql('DROP TABLE eshop_catalog__variant');
		$this->addSql('DROP TABLE eshop_catalog__variant_text');
		$this->addSql('DROP TABLE eshop_catalog__variant_value');
		$this->addSql('DROP TABLE eshop_catalog__variant_value_text');
		$this->addSql('DROP INDEX publish_id_id_lft ON eshop_catalog__category');
		$this->addSql('DROP INDEX root_lft_id ON eshop_catalog__category');
		$this->addSql('ALTER TABLE eshop_catalog__category DROP created, DROP modified');
		$this->addSql('ALTER TABLE eshop_catalog__feature CHANGE position position SMALLINT NOT NULL, CHANGE is_published is_published SMALLINT NOT NULL, CHANGE use_filter use_filter SMALLINT NOT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4DD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4C14ADC16');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE46A018358');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4C14ADC16 FOREIGN KEY (id_feature) REFERENCES eshop_catalog__feature (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE46A018358 FOREIGN KEY (id_feature_value) REFERENCES eshop_catalog__feature_value (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value DROP FOREIGN KEY FK_4DFA2FA560E4B879');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value DROP position, DROP is_published');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value ADD CONSTRAINT FK_4DFA2FA560E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('DROP INDEX id_name ON eshop_catalog__manufacturer');
		$this->addSql('ALTER TABLE eshop_catalog__manufacturer DROP position');
		$this->addSql('DROP INDEX IDX_54FD0ED01D96EA36 ON eshop_catalog__product');
		$this->addSql('DROP INDEX published ON eshop_catalog__product');
		$this->addSql('DROP INDEX published_cat ON eshop_catalog__product');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP id_product_export');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDDD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDCBF180EB');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDDD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDCBF180EB FOREIGN KEY (id_supplier) REFERENCES eshop_catalog__supplier (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('DROP INDEX lang ON eshop_catalog__product_texts');
		$this->addSql('ALTER TABLE eshop_catalog__product_texts CHANGE short_description short_description VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci');
	}
}
