<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190607070722 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_catalog__category_filter (category_id INT NOT NULL, feature_id INT NOT NULL, position INT NOT NULL, INDEX IDX_E700012612469DE2 (category_id), INDEX IDX_E700012660E4B879 (feature_id), PRIMARY KEY(category_id, feature_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__category_filter ADD CONSTRAINT FK_E700012612469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category_filter ADD CONSTRAINT FK_E700012660E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category ADD filters_from_parent SMALLINT DEFAULT 1 NOT NULL');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__category DROP filters_from_parent');
		$this->addSql('DROP TABLE eshop_catalog__category_filter');
	}
}
