<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191210115816 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{

		$this->addSql('CREATE TABLE eshop_catalog__availability (id INT AUTO_INCREMENT NOT NULL, ident VARCHAR(255) NOT NULL, delay SMALLINT UNSIGNED DEFAULT 0 NOT NULL, can_show_on_list SMALLINT DEFAULT 1 NOT NULL, can_show_on_search SMALLINT DEFAULT 1 NOT NULL, can_add_to_cart SMALLINT DEFAULT 1 NOT NULL, color VARCHAR(255) DEFAULT NULL, bg_color VARCHAR(255) DEFAULT NULL, can_delete SMALLINT DEFAULT 1 NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__availability_text (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_8C8FD44ABF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__availability_text ADD CONSTRAINT FK_8C8FD44ABF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__availability (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD id_availability INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED01C76D7CD FOREIGN KEY (id_availability) REFERENCES eshop_catalog__availability (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_54FD0ED01C76D7CD ON eshop_catalog__product (id_availability)');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile  = @file_get_contents(APP_DIR . '/config/config.neon');
		$appConfig   = Neon::decode((string) $configFile);
		$defaultLang = $appConfig['translation']['default'] ?? 'cs';

		$this->connection->insert('eshop_catalog__availability', [
			'ident'      => 'inStock',
			'delay'      => 0,
			'can_delete' => 0,
			'color'      => '#ffffff',
			'bg_color'   => '#28a745',
		]);
		$this->connection->insert('eshop_catalog__availability_text', [
			'id'   => $this->connection->lastInsertId(),
			'lang' => $defaultLang,
			'name' => 'Skladem',
		]);
		$this->connection->insert('eshop_catalog__availability', [
			'ident'           => 'soldOut',
			'delay'           => 0,
			'can_add_to_cart' => 0,
			'can_delete'      => 0,
			'color'           => '#ffffff',
			'bg_color'        => '#dc2033',
		]);
		$this->connection->insert('eshop_catalog__availability_text', [
			'id'   => $this->connection->lastInsertId(),
			'lang' => $defaultLang,
			'name' => 'Vyprodaný',
		]);

		$availabilities = [];
		foreach ($this->connection->fetchAllAssociative("SELECT a.id, a.ident FROM eshop_catalog__availability a;") as $row)
			$availabilities[$row['ident']] = $row['id'];

		$quantities = [];
		foreach ($this->connection->fetchAllAssociative("SELECT p.id, p.quantity FROM eshop_catalog__product p;") as $row) {
			$quantities[$row['id']] = $row['quantity'] ?: 0;
		}

		foreach ($this->connection->fetchAllAssociative("SELECT ps.id_product, ps.quantity FROM eshop_catalog__product_supplier ps;") as $row) {
			$quantities[$row['id_product']] += (int) $row['quantity'];
		}

		foreach ($quantities as $prodId => $quantity) {
			$this->connection->update('eshop_catalog__product', [
				'id_availability' => $availabilities[(int) $quantity > 0 ? 'inStock' : 'soldOut'],
			], ['id' => $prodId]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__availability_text DROP FOREIGN KEY FK_8C8FD44ABF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED01C76D7CD');
		$this->addSql('DROP TABLE eshop_catalog__availability');
		$this->addSql('DROP TABLE eshop_catalog__availability_text');
		$this->addSql('DROP INDEX IDX_54FD0ED01C76D7CD ON eshop_catalog__product');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP id_availability');
	}
}
