<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191215175400 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{

		$this->addSql('UPDATE eshop_catalog__category SET lvl = 0 WHERE lvl = 0');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig  = Neon::decode((string) $configFile);
		$siteName   = $appConfig['parameters']['siteNameAlias'] ?? 'pshkcmssandbox';

		$lvl0Id = $this->connection->fetchOne('SELECT id FROM eshop_catalog__category WHERE lvl = 0 LIMIT 1');

		if ($lvl0Id) {
			$this->connection->update('eshop_catalog__category_texts', [
				'name'  => $siteName,
				'alias' => $siteName,
			], [
				'id' => $lvl0Id,
			]);
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
	}
}
