<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191226154704 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_catalog__seller (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, address VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, postal VARCHAR(255) DEFAULT NULL, country VARCHAR(255) DEFAULT NULL, address2 VARCHAR(255) DEFAULT NULL, city2 VARCHAR(255) DEFAULT NULL, postal2 VARCHAR(255) DEFAULT NULL, country2 VARCHAR(255) DEFAULT NULL, ic VARCHAR(12) DEFAULT NULL, dic VARCHAR(14) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, phone VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__seller_bank_account (id INT AUTO_INCREMENT NOT NULL, seller_id INT NOT NULL, bank_name VARCHAR(255) DEFAULT NULL, number_part1 VARCHAR(255) DEFAULT NULL, number_part2 VARCHAR(255) DEFAULT NULL, swift VARCHAR(255) DEFAULT NULL, iban VARCHAR(255) DEFAULT NULL, INDEX IDX_305E95AE8DE820D9 (seller_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__seller_in_site (id INT AUTO_INCREMENT NOT NULL, seller_id INT NOT NULL, site_id VARCHAR(255) NOT NULL, in_stock SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_66BB479A8DE820D9 (seller_id), INDEX IDX_66BB479AF6BD1646 (site_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__seller_bank_account ADD CONSTRAINT FK_305E95AE8DE820D9 FOREIGN KEY (seller_id) REFERENCES eshop_catalog__seller (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__seller_in_site ADD CONSTRAINT FK_66BB479A8DE820D9 FOREIGN KEY (seller_id) REFERENCES eshop_catalog__seller (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__seller_in_site ADD CONSTRAINT FK_66BB479AF6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE CASCADE');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__seller_bank_account DROP FOREIGN KEY FK_305E95AE8DE820D9');
		$this->addSql('ALTER TABLE eshop_catalog__seller_in_site DROP FOREIGN KEY FK_66BB479A8DE820D9');
		$this->addSql('DROP TABLE eshop_catalog__seller');
		$this->addSql('DROP TABLE eshop_catalog__seller_bank_account');
		$this->addSql('DROP TABLE eshop_catalog__seller_in_site');
	}
}
