<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20220223141637 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD `main_supplier` SMALLINT UNSIGNED DEFAULT 0');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		set_time_limit(1200);
		$list = [];
		foreach ($this->connection->fetchAllAssociative("SELECT id_product, id_supplier FROM eshop_catalog__product_supplier ORDER BY id_supplier ASC") as $row) {
			if (isset($list[$row['id_product']])) {
				continue;
			}

			$list[$row['id_product']] = $row['id_supplier'];
		}

		foreach ($list as $product => $supplier) {
			$this->connection->executeStatement("UPDATE eshop_catalog__product_supplier SET main_supplier = 1 WHERE id_product = {$product} AND id_supplier = {$supplier}");
		}

		parent::postUp($schema);
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__feature DROP `decimals`');
	}
}
