<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Core\Model\Helpers\Strings;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20220726112335 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$offset = 0;
		$i      = 0;
		do {
			$products = $this->connection->fetchAllAssociative("SELECT `id`, `lang`, `alias` FROM eshop_catalog__product_texts LIMIT 1000 OFFSET {$offset}");

			if (!empty($products)) {
				foreach ($products as $row) {
					if (!$row['alias']) {
						continue;
					}

					$alias = Strings::webalize($row['alias']);

					if ($alias !== $row['alias']) {
						$this->connection->executeQuery(
							"UPDATE eshop_catalog__product_texts SET `alias` = ? WHERE `id` = ? AND `lang` = ?",
							[
								$alias,
								$row['id'],
								$row['lang'],
							]
						);
					}
				}
			}

			$i++;
			$offset += 1000;
		} while (!empty($products) && $i < 1000);
	}

	#[Override]
	public function down(Schema $schema): void
	{
	}
}
