<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230102151037 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_catalog__product_price_history_country (id INT AUTO_INCREMENT NOT NULL, product INT DEFAULT NULL, country VARCHAR(255) NOT NULL, currency_code VARCHAR(255) DEFAULT NULL, price NUMERIC(10, 2) NOT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, direction SMALLINT DEFAULT 0 NOT NULL, reason VARCHAR(255) DEFAULT NULL, INDEX IDX_B9AD94B3D34A04AD (product), INDEX IDX_B9AD94B35373C966 (country), INDEX byCountry (direction, country, currency_code, product), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__product_price_history_country ADD CONSTRAINT FK_B9AD94B3D34A04AD FOREIGN KEY (product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_price_history_country ADD CONSTRAINT FK_B9AD94B35373C966 FOREIGN KEY (country) REFERENCES core__country (id) ON DELETE CASCADE');
		$this->addSql('CREATE INDEX byCountry ON eshop_catalog__product_price_history (direction, product)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_catalog__product_price_history_country');
		$this->addSql('DROP INDEX byCountry ON eshop_catalog__product_price_history');
	}
}
