<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230118133745 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE eshop_catalog__product_variant_text (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_3C519EDABF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_text ADD CONSTRAINT FK_3C519EDABF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__product_variant (product_id) ON DELETE CASCADE');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig  = Neon::decode((string) $configFile);
		$langs      = $appConfig['parameters']['translation']['whitelist'] ?? ['cs'];

		foreach ($this->connection->fetchAllAssociative("SELECT product_id, variant_name FROM eshop_catalog__product_variant WHERE variant_name IS NOT NULL") as $row) {
			foreach ($langs as $lang) {
				$this->connection->executeQuery("INSERT IGNORE INTO `eshop_catalog__product_variant_text` (`id`, `lang`, `name`) VALUES (?, ?, ?)", [
					$row['product_id'], $lang, $row['variant_name'],
				]);
			}
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE eshop_catalog__product_variant_text');
	}
}
