<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20231118144105 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__product CHANGE is_deleted is_deleted INT UNSIGNED DEFAULT 0 NOT NULL, CHANGE disable_listing disable_listing SMALLINT UNSIGNED DEFAULT 0 NOT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product_in_site DROP FOREIGN KEY FK_50DB970694309E4');
		$this->addSql('ALTER TABLE eshop_catalog__product_in_site ADD CONSTRAINT FK_50DB970694309E4 FOREIGN KEY (site) REFERENCES core__site (ident) ON DELETE CASCADE');
		$this->addSql('CREATE INDEX catalog_search ON eshop_catalog__product_in_site (product_id, site, is_active)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__category_texts DROP FOREIGN KEY FK_84B94FDBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__category_texts ADD CONSTRAINT FK_84B94FDBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__category (id) ON UPDATE CASCADE ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD id_product_export INT DEFAULT NULL, CHANGE is_deleted is_deleted INT DEFAULT 0 NOT NULL, CHANGE disable_listing disable_listing SMALLINT DEFAULT 0 NOT NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product_in_site DROP FOREIGN KEY FK_50DB970694309E4');
		$this->addSql('DROP INDEX catalog_search ON eshop_catalog__product_in_site');
		$this->addSql('ALTER TABLE eshop_catalog__product_in_site ADD CONSTRAINT FK_50DB970694309E4 FOREIGN KEY (site) REFERENCES core__site (ident) ON UPDATE CASCADE ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier CHANGE main_supplier main_supplier SMALLINT UNSIGNED DEFAULT 0');
	}
}
