<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240204184212 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__vat_rate ADD position INT NOT NULL');
	}

	#[Override]
	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$i = 0;
		foreach ($this->connection->fetchAllAssociative('SELECT id FROM eshop_catalog__vat_rate ORDER BY id') as $vatRate) {
			$this->connection->executeStatement('UPDATE eshop_catalog__vat_rate SET `position` = ? WHERE id = ?', [$i, $vatRate['id']]);
			$i++;
		}
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__vat_rate DROP position');
	}
}
