<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Core\Model\Helpers\Traits\TMigration;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Types\Types;
use Doctrine\Migrations\AbstractMigration;

final class Version20260105102020 extends AbstractMigration
{
	use TMigration;

	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		$this->migrateSerializedColumnToJson('attrs', 'eshop_catalog__category', [
			'id' => Types::INTEGER,
		]);
		$this->migrateSerializedColumnToJson('seo', 'eshop_catalog__category_texts', [
			'id'   => Types::INTEGER,
			'lang' => Types::STRING,
		]);
		$this->migrateSerializedColumnToJson('more_data', 'eshop_catalog__product', [
			'id' => Types::INTEGER,
		]);
		$this->migrateSerializedColumnToJson('seo', 'eshop_catalog__product_texts', [
			'id'   => Types::INTEGER,
			'lang' => Types::STRING,
		]);
		$this->migrateSerializedColumnToJson('params', 'eshop_catalog__data_feed', [
			'id' => Types::INTEGER,
		]);
	}

	public function down(Schema $schema): void
	{
	}
}
