<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use EshopStock\DI\EshopStockExtension;
use Override;

class Config extends \Core\Model\Config
{
	#[Override]
	public static function setParams(array $params): void
	{
		parent::setParams($params);
		self::updateParams();
	}

	protected static function updateParams(): void
	{
		$params = self::$params[static::class];
		$result = $params['config'];

		unset($params['config']);
		foreach ($params as $k => $v) {
			$result[$k] = $v;
		}

		self::$params[static::class] = $result;
	}

	public static function wareHouseExist(): bool
	{
		return class_exists('\EshopProductionWarehouse\DI\EshopProductionWarehouseExtension')
			|| class_exists(EshopStockExtension::class)
			|| self::load('pseudoWarehouse');
	}
}
