<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\AvailabilityService;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AvailabilityListener implements EventSubscriberInterface
{
	use SmartObject;

	protected Cache $cache;

	public function __construct(
		Storage         $storage,
		protected Langs $langs,
	)
	{
		$this->cache = new Cache($storage, AvailabilityService::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param object $entity
	 */
	#[ORM\PreFlush]
	public function onPreFlush($entity, PreFlushEventArgs $args): void
	{
		// TODO cache sluzba
		foreach ($this->langs->getLangs(false) as $lang) {
			$this->cache->remove('availabilities/' . $lang->getTag());
		}
	}

}
