<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__availability_text')]
#[ORM\Entity]
class AvailabilityText
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Availability::class, inversedBy: 'texts')]
	protected Availability $availability;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $name;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	public function __construct(Availability $availability, string $lang, string $name)
	{
		$this->availability = $availability;
		$this->lang         = $lang;
		$this->name         = $name;
	}

}
