<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'eshop_catalog__category_check_products_count')]
class CategoryCheckProductsCount
{
	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 32, nullable: true)]
	public string $categoryId;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $siteIdent = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public ?\DateTime $created;

	public function __construct(string $categoryId)
	{
		$this->categoryId = $categoryId;
		$this->created    = new \DateTime();
	}
}
