<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__category_filter')]
#[ORM\Entity]
#[ORM\EntityListeners(['CategoryFilterListener'])]
class CategoryFilter
{
	#[ORM\JoinColumn(name: 'category_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Category::class, inversedBy: 'filters')]
	public Category $category;

	#[ORM\JoinColumn(name: 'feature_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Feature::class)]
	public Feature $feature;

	#[ORM\Column(type: Types::INTEGER)]
	public int $position = 0;

	#[ORM\Column(type: Types::INTEGER, options: ['default' => 0, 'unsigned' => true])]
	public int $isHidden = 0;

	public function __construct(Category $category, Feature $feature, int $position)
	{
		$this->category = $category;
		$this->feature  = $feature;
		$this->position = $position;
	}

}
