<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryFilterListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(CategoryFilter $categoryFilter, LifecycleEventArgs $event): void
	{
		$this->cacheService->clean('category', [Cache::Tags => ['category/' . $categoryFilter->category->getId()]]);
	}

	#[ORM\PreFlush]
	public function onPreFlush(CategoryFilter $categoryFilter, PreFlushEventArgs $args): void
	{
		$this->cacheService->clean('category', [Cache::Tags => ['category/' . $categoryFilter->category->getId()]]);
	}

}
