<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'eshop_catalog__category_related')]
#[ORM\Index(columns: ['category_id'], name: 'category')]
#[ORM\Entity(repositoryClass: SortableRepository::class)]
class CategoryRelated
{
	use TId;

	/** @Gedmo\SortableGroup */
	#[ORM\JoinColumn(name: 'category_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Category::class, inversedBy: 'related')]
	public Category $category;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true])]
	public int $target;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $targetKey = 'category';

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER, nullable: false)]
	protected int $position = 0;

	public function __construct(Category $category, int $target)
	{
		$this->category = $category;
		$this->target   = $target;
		$this->setPosition(-1);
	}

	public function setPosition(int $pos): void { $this->position = $pos; }

}
