<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__data_feed')]
#[ORM\Entity]
class DataFeed
{
	use TId;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $ident;

	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $url;

	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $entityType = null;

	#[ORM\Column(type: Types::JSON, nullable: true)]
	public ?array $params = null;

	#[ORM\Column(type: Types::SMALLINT, nullable: false, options: ['default' => 1])]
	public int $isActive = 1;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?\DateTime $lastRun = null;

	public function __construct(string $ident)
	{
		$this->ident = $ident;
	}
}
