<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Listeners\DynamicFeatureCategoryListener;

#[ORM\Table(name: 'eshop_catalog__dynamic_feature_category')]
#[ORM\Entity]
#[ORM\EntityListeners([DynamicFeatureCategoryListener::class])]
class DynamicFeatureCategory
{
	use TId;

	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Category::class, cascade: ['persist'], inversedBy: 'dynamicFeatures')]
	public Category $category;

	#[ORM\JoinColumn(name: 'id_feature', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Feature::class, cascade: ['persist'])]
	public Feature $feature;

	#[ORM\Column(name: '`value`', type: Types::STRING, length: 255, nullable: false)]
	public string $value;

	public function __construct(
		Category $category,
		Feature  $feature,
		string   $value
	)
	{
		$this->category = $category;
		$this->feature  = $feature;
		$this->value    = $value;
	}
}
