<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Listeners\DynamicFeatureProductListener;

#[ORM\Table(name: 'eshop_catalog__dynamic_feature_product')]
#[ORM\Entity]
#[ORM\EntityListeners([DynamicFeatureProductListener::class])]
class DynamicFeatureProduct
{
	use TId;

	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist'], inversedBy: 'FeatureProduct')]
	private Product $product;

	#[ORM\JoinColumn(name: 'id_feature', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Feature::class, cascade: ['persist'])]
	private Feature $feature;

	#[ORM\Column(name: '`value`', type: Types::STRING, length: 255, nullable: false)]
	public string $value;

	public function __construct(Product $product, Feature $feature, string $value)
	{
		$this->product = $product;
		$this->feature = $feature;
		$this->value   = $value;
	}

	public function getFeature(): Feature { return $this->feature; }

	public function getProduct(): Product { return $this->product; }

	public function setProduct(Product $product): void { $this->product = $product; }
}
