<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Listeners\FeatureCategoryListener;

#[ORM\Table(name: 'eshop_catalog__feature_category')]
#[ORM\Entity]
#[ORM\EntityListeners([FeatureCategoryListener::class])]
class FeatureCategory
{
	use TId;

	#[ORM\JoinColumn(name: 'id_category', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Category::class, cascade: ['persist'], inversedBy: 'features')]
	public ?Category $category = null;

	#[ORM\JoinColumn(name: 'id_feature_value', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: FeatureValue::class, cascade: ['persist'])]
	public ?FeatureValue $featureValue = null;

	public function __construct(
		Category     $category,
		FeatureValue $featureValue
	)
	{
		$this->category     = $category;
		$this->featureValue = $featureValue;
	}

	public function getFeature(): ?Feature
	{
		return $this->getFeatureValue()?->getFeature();
	}

	public function getFeatureValue(): ?FeatureValue
	{
		return $this->featureValue;
	}
}
