<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use DynamicModule\Model\Entities\FeatureText;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected EntityManagerDecorator $em,
		protected CacheService           $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Feature|FeatureText $entity
	 */
	#[ORM\PostUpdate]
	public function onPostUpdate($entity, LifecycleEventArgs $event): void
	{
		if (!$this->em->getConnection()->isTransactionActive()) {
			$ids = [];

			if ($entity instanceof Feature && $entity->getId() !== null) {
				$ids[] = $entity->getId();
			}

			if ($entity instanceof FeatureText && $entity->feature->getId() !== null) {
				$ids[] = $entity->feature->getId();
			}

			$this->cacheService->clearFeatures($ids);
		}
	}
}
