<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__feature_product')]
#[ORM\Entity]
#[ORM\EntityListeners([FeatureProductListener::class])]
class FeatureProduct
{
	use TId;

	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist'], inversedBy: 'FeatureProduct')]
	private ?Product $product = null;

	#[ORM\JoinColumn(name: 'id_feature_value', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: FeatureValue::class, cascade: ['persist'])]
	private ?FeatureValue $featureValue = null;

	public function __construct(Product $product, FeatureValue $featureValue)
	{
		$this->product      = $product;
		$this->featureValue = $featureValue;
	}

	public function getFeature(): ?Feature
	{
		return $this->getFeatureValue()?->getFeature();
	}

	public function getFeatureValue(): ?FeatureValue
	{
		return $this->featureValue;
	}

	public function getIdProduct(): ?int
	{
		return $this->product->getId();
	}

	public function getIdFeature(): ?int
	{
		return $this->getFeature()?->getId();
	}

	public function getIdFeatureValue(): ?int
	{
		return $this->featureValue->getId();
	}

	public function setFeature(Feature $feature): void
	{
	}

	public function setFeatureValue(FeatureValue $featureValue): void
	{
		$this->featureValue = $featureValue;
	}

	public function setProduct(Product $product): void { $this->product = $product; }
}
