<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Strings;

#[ORM\Table(name: 'eshop_catalog__feature_value_texts')]
#[ORM\Index(columns: ['id', 'lang'], name: 'feature_value')]
#[ORM\Entity]
#[ORM\EntityListeners([FeatureValueListener::class])]
class FeatureValueTexts
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: FeatureValue::class, inversedBy: 'featureValueTexts')]
	private FeatureValue $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	private string $lang;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $rodM = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $rodZ = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $rodS = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $tagText = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $shortDescription = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $longDescription = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $heurekaName = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $zboziName = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $googleName = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $idealoName = null;

	public function __construct(FeatureValue $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getFeatureValue(): FeatureValue { return $this->id; }

	public function getLang(): string
	{
		return $this->lang;
	}

	public function setName(string $name): self
	{
		$this->name = Strings::truncate($name, 255, '');

		return $this;
	}

}
