<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Country;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'eshop_catalog__manufacturer')]
#[ORM\Index(name: 'id_name', columns: ['id', 'name'])]
#[ORM\Entity]
#[ORM\EntityListeners([ManufacturerListener::class])]
class Manufacturer
{
	use TId;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $name;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $logo = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $website = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1)]
	public int $isPublished;

	/** @var Collection<string, ManufacturerTexts> */
	#[ORM\OneToMany(targetEntity: ManufacturerTexts::class, mappedBy: 'id', cascade: ['all'], indexBy: 'lang')]
	public Collection $texts;

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER)]
	private int $position = 0;

	#[ORM\JoinColumn(name: 'country_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Country::class)]
	public ?Country $country = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $street = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $zipCode = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $city = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $email = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $contactLink = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $phone = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $remoteId = null;

	#[ORM\Column(type: Types::INTEGER, nullable: true)]
	public ?int $leadTimeDays = null;

	public function __construct()
	{
		$this->texts       = new ArrayCollection;
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	public function getText(string $lang): ?ManufacturerTexts { return $this->texts->get($lang); }

	/**
	 * @return Collection<string, ManufacturerTexts>
	 */
	public function getTexts(): Collection { return $this->texts; }

	/******
	 * === Position
	 */

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

}
