<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__manufacturer_texts')]
#[ORM\Entity]
#[ORM\EntityListeners([ManufacturerListener::class])]
class ManufacturerTexts
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Manufacturer::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	private Manufacturer $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	private string $lang;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	public function __construct(Manufacturer $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getLang(): string
	{
		return $this->lang;
	}

	public function getManufacturer(): Manufacturer { return $this->id; }

}
